export function detectSourceType(source) {
  const extension = source.split(".").pop().toLowerCase();
  const typeMap = {
    mp4: "video/mp4",
    webm: "video/webm",
    ogv: "video/ogg",
    // Audio types
    mp3: "audio/mpeg",
    m4a: "audio/mp4",
    aac: "audio/aac",
    wav: "audio/wav",
    oga: "audio/ogg",
    ogg: "audio/ogg",
    // Encrypted Media Extensions
    m3u8: "application/x-mpegURL",
    mpd: "application/dash+xml",
  };

  return typeMap[extension] || "video/mp4";
}

export function isAudioMime(type) {
  return typeof type === "string" && type.startsWith("audio/");
}
